@php use Illuminate\Support\Facades\Auth, Netzperfekt\SaasBase\Models\UserType, Netzperfekt\SaasCodoc\Enums\OrganisationType; @endphp

<div>
    <div class="text-xl">
        @if(OrganisationType::isPrivateUser(Auth()->user()))
            Meine Angaben
        @else
            Eigene Organisation
        @endif
    </div>

    <div class="mt-6 p-1 leading-7 flex flex-wrap">
        <span class="w-1/5 font-semibold">Name:</span>
        <span class="w-4/5 font-semibold">{{ $myOrganisation->title }}</span>

        @if( ! empty($myOrganisation->company1) ||  ! empty($myOrganisation->company2))
            <span class="w-1/5 font-semibold">Firma</span>
            <span class="w-4/5">{{ $myOrganisation->company1 }} {{ $myOrganisation->company2 }}</span>
        @endif

        <span class="w-1/5 font-semibold">Anschrift:</span>
        <span class="w-4/5">{{ $myOrganisation->street }}</span>

        <span class="w-1/5 font-semibold">PLZ / Ort:</span>
        <span class="w-4/5">{{ $myOrganisation->zip }} {{ $myOrganisation->city }}, {{ $myOrganisation->country }}</span>

        <span class="w-1/5 font-semibold">Telefon</span>
        <span class="w-4/5">{{ $myOrganisation->phone }}</span>

        <span class="w-1/5 font-semibold">E-Mail</span>
        <span class="w-4/5">{{ $myOrganisation->email }}</span>

        <span class="w-1/5 font-semibold">Homepage</span>
        <span class="w-4/5">{{ $myOrganisation->homepage }}</span>

        <span class="w-1/5 font-semibold mt-4">Kontakt</span>
        <span class="w-4/5 text-sm">{!! $myOrganisation->contact  !!}</span>
    </div>

    @if(count($myOrganisation->additional ?? []) > 0)
        <div class="mt-4 p-1 bg-gray-100 flex flex-wrap text-sm">
            @foreach($myOrganisation->additional as $key => $value)
                @if(! empty($value))
                    <span class="w-1/5 font-semibold">{{ __('codoc-additional-' . $key) }}:</span>
                    <span class="w-4/5">{!! $value !!}</span>
                @endif
            @endforeach
        </div>
    @endif

    @if($codoc['with_history'])
        @include('saas-codoc::pdf._history', ['history' => $myOrganisation->comments])
    @endif
</div>

