@php use Netzperfekt\SaasCodoc\Enums\ServiceStatus; @endphp

@if($services && count($services) > 0)
<div class="break-inside-avoid">
    <div class="mt-6 text-sm text-gray-600 font-bold">
        GENUTZTE SERVICES
    </div>

    <table class="table-auto border-separate border-spacing-y-2 text-sm text-left w-full">
        @if(count($services) > 5)
            <thead class="text-left underline font-normal text-gray-400">
                <tr>
                    <th></th>
                    <th class="w-3/12">Bezeichnung</th>
                    <th class="w-2/12">Bereitgestellt von</th>
                    <th class="w-7/12">Zusatzinformationen</th>
                </tr>
            </thead>
        @endif

        <tbody>
            @foreach($services as $service)
                <tr class="align-top">
                    <td class="inline-block me-1 text-gray-400">
                        {{ $loop->iteration }}
                    </td>
                    <td class="w-3/12">
                        <div class="font-semibold">{{ $service->pivot->service_title ?? $service->title }}</div>
                        <div class="mt-1 font-normal text-xs text-gray-400">
                            {{ $service->title }}
                            &bull;
                            {{ $service->type->getLabel() }}
                            &bull;
                            {{ $service->pivot->service_status->getLabel() }}

                            @if(count($service->pivot->service_documents ?? []) == 1)
                                &bull;
                                <b>[1 Dokument]</b>
                            @elseif(count($service->pivot->service_documents ?? []) > 0)
                                &bull;
                                <b>[{{ count($service->pivot->service_documents) }} Dokumente]</b>
                            @endif
                        </div>
                    </td>
                    <td class="w-2/12">
                        {{ $service->pivot->organisationProvided?->title ?? '-' }}
                    </td>
                    <td class="w-7/12">
                        @if($service->pivot->service_additional)
                            @foreach($service->pivot->service_additional as $key => $value)
                                <div class="mb-2">
                                    <span class="text-sm bg-gray-100 p-1">{{ $key }}</span>
                                    <span class="text-sm font-semibold">{{ $value }}</span>
                                </div>
                            @endforeach
                        @endif

                        @if($codoc['with_history'] && ($service->pivot->service_description ?? $service->description))
                            <div class="p-1 text-sm bg-gray-100">
                                {!! $service->pivot->service_description ?? $service->description !!}
                            </div>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif
