@php use Netzperfekt\SaasCodoc\Enums\OrganisationType;use Netzperfekt\SaasCodoc\Models\Organisation; @endphp
@include('saas-codoc::pdf._layout')

@if($codoc['with_qrcode'])
    @include('saas-codoc::pdf._qrcode', ['link' => getExportLink($codoc, Auth()->user()->id)])
@endif

@if($codoc['mydata'])
    @include('saas-codoc::pdf._mydata', ['myOrganisation' => $codoc['myorganisation']])
    @pageBreak
@endif

<div>
    @php
        $oldType = null;
        $firstPage = true;
    @endphp

    @foreach($codoc['organisations'] as $type => $organisationsPerType)
        @foreach($organisationsPerType as $organisation)

            @if($type != $oldType)
                @if( ! $firstPage)
                    @pageBreak
                @endif

                <div class="text-xl p-2">
                    {{ OrganisationType::from($type)->getLabel() }}
                </div>

                @php
                    $oldType = $type;
                    $firstPage = false;
                @endphp

            @endif

            <div class="mt-4 p-2 odd:bg-gray-50">
                <div>
                    <span class="font-semibold text-xl">
                        {{ $organisation->title }}
                    </span>

                    @if($organisation->subtype && $organisation->subtype != OrganisationType::None)
                        <span class="ms-3 me-3 p-2 bg-gray-100 text-sm">{{ $organisation->subtype->getLabel() }}</span>
                    @endif

                    @include('saas-codoc::pdf._tags', ['tags' => $organisation->authorization_tags])
                </div>

                <div class="mt-2 mb-4">
                    @include('saas-codoc::pdf._contact', ['organisation' => $organisation])
                </div>

                @if($codoc['with_history'])
                    @if($organisation->contact)
                        <div class="mt-2 mb-2 p-1 text-sm bg-gray-100">
                            {!! $organisation->contact !!}
                        </div>
                    @endif
                    @if($organisation->description)
                        <div class="mt-2 mb-2 p-1 text-sm bg-gray-100">
                            {!! $organisation->description !!}
                        </div>
                    @endif
                @endif

                @if(count($organisation->additional ?? []) > 0)
                    <div class="mt-2">
                        @foreach($organisation->additional as $key => $value)
                            @if(! empty($value))
                                <span class="p-1 me-1 mb-1 text-sm bg-gray-100 inline-block w-full">
                                    {{ __('codoc-additional-' . $key) }}: <span class="font-semibold">{!! $value !!}</span>
                                </span>
                            @endif
                        @endforeach
                    </div>

                    @if(count($organisation->documents ?? []) == 1)
                        <span class="p-1 me-1 text-sm bg-gray-100 inline-block font-bold">[1 Dokument online verfügbar]</span>
                    @elseif(count($organisation->documents ?? []) > 0)
                        <span class="p-1 me-1 text-sm bg-gray-100 inline-block font-bold">[{{ count($organisation->documents) }} Dokumente online verfügbar]</span>
                    @endif
                @endif

                @if(count($organisation->assigned_organisations ?? []) > 0)
                    <div class="mt-2 mb-4">
                        Zugeordnete Organisationen/Kontakte:&nbsp;
                        @foreach($organisation->assigned_organisations as $assignedOrganisation)
                            <span class="p-2 bg-gray-100 text-sm">{{ Organisation::find($assignedOrganisation)?->title ?? '???' }}</span>
                        @endforeach
                    </div>
                @endif

                @if($codoc['used'])
                    @include('saas-codoc::pdf._services_used', ['services' => $organisation->servicesUsing])
                @endif

                @if($codoc['provided'])
                    @include('saas-codoc::pdf._services_provided', ['services' => $organisation->servicesProviding])
                @endif

                @if($codoc['assets'])
                    @include('saas-codoc::pdf._assets', ['assets' => $organisation->assets])
                @endif

                @if($codoc['with_history'])
                    @include('saas-codoc::pdf._history', ['history' => $organisation->comments])
                @endif
            </div>

        @endforeach
    @endforeach
</div>

@include('saas-codoc::pdf._layoutbody')
