<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['web'])->group(function ()
{
    Route::get('/codoc/_export/data',
        [\Netzperfekt\SaasCodoc\Controllers\DataController::class, 'exportData'])
        ->name('codoc.export.data');

    Route::get('/export/{link}',
        [\Netzperfekt\SaasCodoc\Controllers\DataController::class, 'exportCodoc'])
        ->name('codoc.export.codoc');

    Route::get('/codoc/_shared/all/{token}',
        [\Netzperfekt\SaasCodoc\Controllers\ShareController::class, 'getAll'])
        ->name('codoc.shared.all');

    Route::get('/codoc/_shared/project/{projectId}/{token}',
        [\Netzperfekt\SaasCodoc\Controllers\ShareController::class, 'getProject'])
        ->name('codoc.shared.project');
});
