<?php

namespace Netzperfekt\SaasCodoc\Commands;

use Illuminate\Console\Command;
use Netzperfekt\SaasCodoc\Models\Asset;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Models\OrganisationProvidesServices;
use Netzperfekt\SaasCodoc\Models\OrganisationUsesServices;
use Netzperfekt\SaasCodoc\Models\Service;
use Netzperfekt\SaasCodoc\Models\ServicesComponents;
use Vildanbina\ModelJson\Services\ExportService;

class ExportCodocCommand extends Command
{
    protected $signature = 'app:codoc-export';

    protected $description = 'Exports CoDoc organisations and services';

    public function handle()
    {
        $this->exportOrganisations();
    }

    private function exportOrganisations()
    {
        $this->exportJson(Organisation::class, 'organisations', 'Exporting Organisations...');

        $this->exportJson(Asset::class, 'assets', 'Exporting Assets...');

        $this->exportJson(Service::class, 'services', 'Exporting Services...');
        $this->exportJson(ServicesComponents::class, 'services-components', 'Exporting Services/Components...');

        $this->exportJson(OrganisationUsesServices::class, 'organisations-uses-services', 'Exporting Orgsniations/using Services...');
        $this->exportJson(OrganisationProvidesServices::class, 'organisations-provides-services', 'Exporting Orgsniations/providing Services...');

        $zip = new \ZipArchive();
        $zipFileName = storage_path('app/codoc.zip');

        if ($zip->open($zipFileName, \ZipArchive::CREATE) === true)
        {
            $filesToZip = [
                storage_path('app/organisations.json'),
                storage_path('app/assets.json'),
                storage_path('app/services.json'),
                storage_path('app/services-components.json'),
                storage_path('app/organisations-uses-services.json'),
                storage_path('app/organisations-provides-services.json'),
            ];

            foreach ($filesToZip as $file) {
                $zip->addFile($file, basename($file));
            }

            $zip->close();

        }
        else {
            $this->output->newline();
            $this->output->error('Failed to created ZIP.');

            return COMMAND::FAILURE;
        }

        foreach($filesToZip as $fileName)
        {
            unlink($fileName);
        }

        $this->output->newLine();
        $this->output->success('Created ZIP: ' . $zipFileName);
        $this->output->newLine();

        return Command::SUCCESS;
    }

    private function exportJson(string $modelClass, string $fileName, string $title, $relations = ''): string
    {
        $this->output->newLine();
        $this->output->write($title);
        $this->output->newLine();

        $exportService = ExportService::make()
            ->setModel($modelClass)
            ->setFilename($fileName)
            ->setRelationships($relations)
            ->beautifyJson(true)
            ->onEach(function () {
                $this->output->progressAdvance();
            });

        $this->output->progressStart($exportService->getTotalModelsCount());

        $path = $exportService->run();
        $this->output->progressFinish();

        $this->output->success('Exported to: ' . $path);

        return $path;
    }
}
