<?php

namespace Netzperfekt\SaasCodoc\Commands;

use Illuminate\Console\Command;
use Netzperfekt\SaasCodoc\Models\Asset;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Models\OrganisationProvidesServices;
use Netzperfekt\SaasCodoc\Models\OrganisationUsesServices;
use Netzperfekt\SaasCodoc\Models\Service;
use Netzperfekt\SaasCodoc\Models\ServicesComponents;
use Vildanbina\ModelJson\Services\ImportService;

class ImportCodocCommand extends Command
{
    protected $signature = 'app:codoc-import';

    protected $description = 'Imports CoDoc organisations and services';

    public function handle()
    {
        $this->importOrganisations();
    }

    private function importOrganisations()
    {
        $this->importJson(Organisation::class, 'organisations', 'Importing Organisations...');

        $this->importJson(Asset::class, 'assets', 'Importing Assets...');

        $this->importJson(Service::class, 'services', 'Importing Services...');
        $this->importJson(ServicesComponents::class, 'services-components', 'Importing Services/Components...');

        $this->importJson(OrganisationUsesServices::class, 'organisations-uses-services', 'Importing Organisations/using Services...');
        $this->importJson(OrganisationProvidesServices::class, 'organisations-provides-services', 'Importing Organisations/providing Services...');

        return Command::SUCCESS;
    }

    private function importJson(string $modelClass, string $fileName, string $title, $relations = ''): string
    {
        $this->output->newLine();
        $this->output->write($title);
        $this->output->newLine();

        $importService = ImportService::make()
            ->setModel($modelClass)
            ->setPath('/storage/app/' . $fileName . '.json')
            ->updateWhenExists(true)
            ->setRelationships($relations)
            ->onEach(function () {
                $this->output->progressAdvance();
            });

        $this->output->progressStart($importService->getTotalModelsCount());

        $path = $importService->run();
        $this->output->progressFinish();

        $this->output->success('Imported.');

        return $path;
    }
}
