<?php

namespace Netzperfekt\SaasCodoc\Controllers;

use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasBase\Models\User;
use Netzperfekt\SaasCodoc\Enums\OrganisationType;
use Netzperfekt\SaasCodoc\Filament\ExportForm;
use Netzperfekt\SaasCodoc\Models\ExportLink;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Services\ExportService;

class DataController extends Controller
{
    // TODO refactor to service, call via custom page with parameters, not navigationitem in panelprovider
    public function exportData()
    {
        if( ! Auth::check() || ! Auth::user()?->isSuperAdmin())
        {
            abort(404);
        }

        Artisan::call('app:codoc-export');

        $fileName = 'codoc.zip';
        $headers = array(
            'Content-Type: application/zip',
        );

        Notification::make()
            ->title(__('codoc-notification-downloaded'))
            ->success()
            ->send();

        return response()->download(storage_path('app/' . $fileName), $fileName, $headers);
    }

    public function exportCodoc(string $link)
    {
        $exportLink = ExportLink::where('link', $link)->first();
        if( ! $exportLink)
        {
            abort(404, 'link not found');
        }

        $params = $exportLink->params;
        $organisationIds = $params['organisations'];

        $organisations = Organisation::find($organisationIds);
        $params['organisations'] = $organisations->sortBy(function($model) use ($organisationIds)
        {
            return array_search($model->getKey(), $organisationIds);
        });
        $params['myorganisation'] = Organisation::find($params['myorganisation'])->first();

        $user = User::find($params['user']);
        $team = $user->mainTeam();

        $organisations = Organisation
            ::where('team_id', $team->id)
            ->get()
            ->sortBy('title', SORT_NATURAL|SORT_FLAG_CASE)
            ->groupBy('type');

        $myOrganisation = Organisation
            ::where('team_id', $team->id)
            ->whereIn('type', [ OrganisationType::OwnOrganisation ])
            ->get()
            ->first();

        Auth::onceUsingId($user->id);

        return response()->streamDownload(function () use ($params, $organisations, $myOrganisation)
        {
            $params = [
                'organisations'  => $organisations,
                'myorganisation' => $myOrganisation,
                'mydata'         => $params['mydata'],
                'provided'       => $params['provided'],
                'used'           => $params['used'],
                'assets'         => $params['assets'],
                'with_history'   => $params['with_history'],
                'with_qrcode'    => false,
            ];

            echo app(ExportService::class)
                ->createExportPDF($params)
                ->toResponse(request());
        }, ExportForm::getExportFileName());
    }
}
