<?php

namespace Netzperfekt\SaasCodoc\Controllers;

use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;
use Netzperfekt\SaasBase\Models\User;
use Netzperfekt\SaasCodoc\Enums\ActivityLogType;
use Netzperfekt\SaasCodoc\Models\Service;

class ShareController extends Controller
{
    public function getAll(Request $request, string $token)
    {
        if ( ! User::getConfig('share_all'))
        {
            abort(401);
        }

        if (! $request->hasValidSignature()) {
            abort(401);
        }

        $sanctumToken = PersonalAccessToken::where('token', $token)->first();
        if ( ! $sanctumToken)
        {
            abort(401);
        }

        $user = $sanctumToken->tokenable;
        if ( ! $user)
        {
            abort(401);
        }

        // TODO get all data to be shared from $user
        $allData = [];

        activity()
            ->by($user)
            ->withProperties([
                'ip'        => $request->getClientIp(),
                'useragent' => $request->userAgent()
            ])
            ->log(ActivityLogType::ShareRetrieveAll->value);

        return view('saas-codoc::frontend.shared.all', [
            'user' => $user->name,
            'data' => $allData
        ]);
    }

    public function getProject(Request $request, string $projectId, string $token)
    {
        if ( ! User::getConfig('share_projects'))
        {
            abort(401);
        }

        if (! $request->hasValidSignature()) {
            abort(401);
        }

        $sanctumToken = PersonalAccessToken::where('token', $token)->first();
        if ( ! $sanctumToken)
        {
            abort(401);
        }

        $user = $sanctumToken->tokenable;
        if ( ! $user)
        {
            abort(401);
        }

        if($sanctumToken->name != config('saas-codoc.token_name_projects') . $projectId)
        {
            abort(401);
        }

        // TODO maybe not expose all project data here to view?
        $project = Service::where('id', $projectId)->firstOrFail();

        activity()
            ->by($user)
            ->performedOn($project)
            ->withProperties([
                'ip'        => $request->getClientIp(),
                'useragent' => $request->userAgent()
            ])
            ->log(ActivityLogType::ShareRetrieveProject->value);

        return view('saas-codoc::frontend.shared.project', [
            'user' => $user->name,
            'data' => $project
        ]);
    }


}
