<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Colors\Color;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum AssetStatus: int implements HasLabel, HasIcon, HasColor
{
    case Active     =  0;
    case Amortized  =  1;
    case Gone       =  2;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Active    => __('codoc-enum-asset-status-active'),
            self::Amortized => __('codoc-enum-asset-status-amortized'),
            self::Gone      => __('codoc-enum-asset-status-gone')
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Active    => 'fas-circle-check',
            self::Amortized => 'fas-circle-xmark',
            self::Gone      => 'fas-skull',
        };
    }

    public function getColor(): ?string
    {
        return match ($this) {
            self::Active    => 'success',
            self::Amortized => 'warning',
            self::Gone      => 'danger',
        };
    }
}
