<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum AssetType: int implements HasLabel, HasIcon
{
    case Hardware    =  0;
    case Software    =  1;
    case Other       = 99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Hardware  => __('codoc-enum-asset-hardware'),
            self::Software  => __('codoc-enum-asset-software'),
            self::Other     => __('codoc-enum-asset-other'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Hardware => 'fas-laptop',
            self::Software => 'fas-floppy-disk',
            self::Other    => 'fas-ellipsis'
        };
    }
}
