<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum OrganisationStatus: int implements HasLabel, HasIcon, HasColor
{
    case Active    =   0;
    case Inactive  =   9;
    case Archived  =  10;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Active    => __('codoc-enum-asset-status-active'),
            self::Inactive  => __('codoc-enum-service-status-inactive'),
            self::Archived  => __('codoc-enum-service-status-archived'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Active    => 'fas-circle-check',
            self::Inactive  => 'fas-circle-xmark',
            self::Archived  => 'fas-box-archive',
        };
    }

    public function getColor(): ?string
    {
        return match ($this)
        {
            self::Active     => 'success',
            self::Inactive   => 'danger',
            self::Archived   => 'gray',
        };
    }
}
