<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Contracts\HasLabel;

enum ServiceDocType: int implements HasLabel
{
    case Default      = 0;
    case Modification = 1;
    case Attachments  = 2;
    case Maintenance  = 3;
    case Decision     = 9;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Default      => __('codoc-enum-service-doc-default'),
            self::Modification => __('codoc-enum-service-doc-modification'),
            self::Attachments  => __('codoc-enum-service-doc-attachments'),
            self::Maintenance  => __('codoc-enum-service-doc-maintenance'),
            self::Decision     => __('codoc-enum-service-doc-decision'),
        };
    }
}
