<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ServiceStatus: int implements HasLabel, HasIcon, HasColor
{
    case Active      =   0;
    case Current     =   1;
    case Productive  =   2;
    case OnHold      =   8;
    case Inactive    =   9;
    case Archived    =  10;

    public function getLabel(): ?string
    {
        return match ($this)
        {
            self::Active     => __('codoc-enum-service-status-active'),
            self::Current    => __('codoc-enum-service-status-current'),
            self::Productive => __('codoc-enum-service-status-productive'),
            self::OnHold     => __('codoc-enum-service-status-onhold'),
            self::Inactive   => __('codoc-enum-service-status-inactive'),
            self::Archived   => __('codoc-enum-service-status-archived'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this)
        {
            self::Active     => 'fas-circle-check',
            self::Current    => 'fas-circle-check',
            self::Productive => 'fas-circle-check',
            self::OnHold     => 'fas-hourglass-start',
            self::Inactive   => 'fas-circle-xmark',
            self::Archived   => 'fas-box-archive',
        };
    }

    public function getColor(): ?string
    {
        return match ($this)
        {
            self::Active     => 'success',
            self::Current    => 'success',
            self::Productive => 'success',
            self::OnHold     => 'info',
            self::Inactive   => 'danger',
            self::Archived   => 'gray',
        };
    }

    public static function getCasesForType(ServiceType $serviceType): array
    {
        return match($serviceType)
        {
            ServiceType::Project => [
                ServiceStatus::Current, ServiceStatus::Productive, ServiceStatus::OnHold, ServiceStatus::Archived
            ],

            default => [
                ServiceStatus::Active, ServiceStatus::Inactive, ServiceStatus::Archived
            ]
        };
    }

    public static function getOptionsForType(ServiceType $serviceType): array
    {
        $options = [];

        $casesForType = self::getCasesForType($serviceType);
        foreach($casesForType as $case)
        {
            $options[$case->value] = $case->getLabel();
        }

        return $options;
    }

}
