<?php

namespace Netzperfekt\SaasCodoc\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ServiceType: int implements HasLabel, HasIcon
{
    case Saas        =  0;
    case Classic     =  1;
    case AppStore    =  2;
    case Local       =  3;

    case Project     = 10;
    case Share       = 11;

    case Legal       = 22;
    case Banking     = 23;

    case Consulting  = 30;

    case Membership  = 50;

    case Other       = 99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Saas       => __('codoc-enum-service-saas'),
            self::Classic    => __('codoc-enum-service-classic'),
            self::AppStore   => __('codoc-enum-service-appstore'),
            self::Local      => __('codoc-enum-service-local'),
            self::Project    => __('codoc-enum-service-project'),
            self::Share      => __('codoc-enum-service-share'),
            self::Legal      => __('codoc-enum-service-legal'),
            self::Banking    => __('codoc-enum-service-banking'),
            self::Consulting => __('codoc-enum-service-consulting'),
            self::Membership => __('codoc-enum-service-membership'),
            self::Other      => __('codoc-enum-service-other'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Saas       => 'fas-cloud',
            self::Classic    => 'fas-cloud-arrow-down',
            self::AppStore   => 'fab-app-store',
            self::Local      => 'fas-database',
            self::Project    => 'fas-lightbulb',
            self::Share      => 'fas-sack-dollar',
            self::Legal      => 'fas-section',
            self::Banking    => 'fas-credit-card',
            self::Consulting => 'fas-person-walking-luggage',
            self::Membership => 'fas-users-rectangle',
            self::Other      => 'fas-bell-concierge'
        };
    }

    public static function getDefaultAdditionalFieldTemplate(): array
    {
        return [
            'Kundennummer' => ''
        ];
    }
}
