<?php

namespace Netzperfekt\SaasCodoc\Filament\Pages;

use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Concerns\InteractsWithFormActions;
use Filament\Pages\Page;
use Netzperfekt\SaasCodoc\Filament\Components\Dependency;

class Dependencies extends Page implements HasForms
{
    use InteractsWithFormActions;

    protected static ?string $navigationIcon = 'fas-arrows-to-eye';
    protected static string $view = 'saas-codoc::filament.dependency-page';

    protected static ?int $navigationSort = 99;

    protected function getFormSchema(): array
    {
        return [
            Dependency::make('')
                ->label('D3 test'),
        ];
    }

    public static function getNavigationGroup(): ?string
    {
        return config('app.name');
    }

    public static function getNavigationLabel(): string
    {
        return __('dependencies');
    }

    public function getTitle(): string
    {
        return __('dependencies');
    }
}
