<?php

namespace Netzperfekt\SaasCodoc\Filament\Pages;

use Filament\Forms\Contracts\HasForms;
use Filament\Notifications\Notification;
use Filament\Pages\Concerns\InteractsWithFormActions;
use Filament\Pages\Page;
use Filament\Actions;
use Illuminate\Contracts\Support\Htmlable;
use Netzperfekt\SaasCodoc\Filament\ExportForm;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Services\ExportService;

class ExportDocumentation extends Page implements HasForms
{
    use InteractsWithFormActions;

    protected static ?string $navigationIcon = 'heroicon-o-document-arrow-down';
    protected static ?int $navigationSort = 99;

    protected static string $view = 'saas-codoc::filament.export-documentation';

    public array $data;
    private ExportService $exportService;

    public function getTitle(): string | Htmlable
    {
        return __('export_documentation');
    }

    public static function getNavigationLabel(): string
    {
        return __('export_documentation');
    }

    public static function getNavigationGroup(): ?string
    {
        return config('app.name');
    }

    public function __construct()
    {
        $this->exportService = app(ExportService::class);
    }

    protected function getFormSchema(): array
    {
        return ExportForm::getExportForm();
    }

    protected function getFormActions(): array
    {
        return [
            Actions\Action::make('export')
                ->label(__('export'))
                ->action(function ($action)
                {
                    if( ! Organisation::getOwnCompany())
                    {
                        Notification::make()
                            ->title(__('codoc-notification-no-organisation'))
                            ->danger()
                            ->send();

                        $action->cancel();
                    }

                    return response()->streamDownload(function ()
                    {
                        $params = [
                            'mydata'   => $this->data['mydata'] ?? false,
                            'used'     => $this->data['used'] ?? false,
                            'provided' => $this->data['provided'] ?? false,
                            'assets'   => $this->data['assets'] ?? false,
                            'history'  => $this->data['history'] ?? false,
                            'qrcode'   => $this->data['qrcode'] ?? false,
                        ];

                        $organisations = Organisation
                            ::onlyMyRecords()
                            ->get()
                            ->sortBy('title', SORT_NATURAL|SORT_FLAG_CASE)
                            ->groupBy('type');

                        echo app(ExportService::class)
                            ->exportOrganisations($organisations, $params)
                            ->toResponse(request());
                    }, ExportForm::getExportFileName());
                })
        ];
    }

    public function mount(): void
    {
        $this->form->fill([
            'mydata'       => true,
            'used'         => true,
            'provided'     => true,
            'history'      => true,
            'assets'       => false,
            'qrcode'       => false,
        ]);
    }

    protected function getFormStatePath(): string
    {
        return 'data';
    }
}
