<?php

namespace Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Netzperfekt\SaasCodoc\Enums\OrganisationType;

class OrganisationAdditionalFields
{
    public static function getAdditionalFields(?OrganisationType $type): array
    {
        if (!$type || OrganisationType::isBusinessUser()) {
            return self::getAdditionalFieldsForBusinessUser($type);
        }

        return self::getAdditionalFieldsForPrivateUser($type);
    }

    private static function getAdditionalFieldsForBusinessUser(OrganisationType $type): array
    {
        $fields = [];

        if($type == OrganisationType::OwnOrganisation)
        {
            $fields = array_merge($fields, [
                RichEditor::make('additional.business_model')
                    ->columnSpanFull()
                    ->label(__('codoc-additional-business_model'))
            ]);
        }

        return $fields;
    }

    private static function getAdditionalFieldsForPrivateUser(OrganisationType $type): array
    {
        $fields = [];

        if($type->isNaturalPerson())
        {
            $fields = array_merge($fields, [
                DatePicker::make('additional.birthday')
                    ->label(__('codoc-additional-birthday'))
                    ->timezone('UTC')
                    ->displayFormat('d.m.Y'),

                TextInput::make('additional.birthplace')
                    ->label(__('codoc-additional-birthplace'))
                    ->maxLength(255)
            ]);
        }

        if($type == OrganisationType::OwnOrganisation)
        {
            $fields = array_merge($fields, [
                Placeholder::make('')->columns(1),

                TextInput::make('additional.marital_status')
                    ->label(__('codoc-additional-marital_status'))
                    ->maxLength(50),

                TextInput::make('additional.religion')
                    ->label(__('codoc-additional-religion'))
                    ->maxLength(100),

                TextInput::make('additional.no_kids')
                    ->label(__('codoc-additional-no_kids'))
                    ->default(0)
                    ->numeric()
                    ->minValue(0)
                    ->maxValue(99),

                TextInput::make('additional.social_security')
                    ->label(__('codoc-additional-social_security'))
                    ->maxLength(100),

                TextInput::make('additional.tax_id')
                    ->label(__('codoc-additional-tax_id'))
                    ->maxLength(100),

                Textarea::make('additional.comments')
                    ->columnSpanFull()
                    ->label(__('codoc-additional-comments'))
            ]);
        }

        return $fields;
    }
}