<?php

namespace Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;

class EditOrganisationPage extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = OrganisationPageResource::class;

    #[Url]
    public string $deeplink = '';
    public bool $deeplinkViewed = false;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
            Actions\Action::make('toggleFavorite')
                ->label(__('codoc-is-favorite'))
                ->icon(fn($record) => $record->is_favorite ? 'fas-star' : 'far-star')
                ->action('toggleFavorite')
            ];
    }

    public function toggleFavorite()
    {
        $this->record->toggleFavorite();
        $this->record->save();
    }

    #[On('parse-deeplink')]
    public function parseDeeplink()
    {
        // thx to https://gist.github.com/lucacastelnuovo/ae7d617c1c57c0047ac40804f2166c8e
        if ($this->deeplinkViewed)
        {
            return;
        }

        $deeplink = explode('-', $this->deeplink, limit: 3);

        if (3 === count($deeplink))
        {
            [$type, $action, $id] = $deeplink;

            $types = ['servicesusing', 'servicesproviding'];

            if (!in_array($type, $types)) {
                return;
            }

            /**
             * This code auto-switches to the correct relation manager.
             * This is necessary because otherwise the actions cannot execute.
             */
            if ($this->activeRelationManager !== $type) {
                $this->activeRelationManager = $type;

                return;
            }

            $this->deeplinkViewed = true;
            $this->dispatch("deeplink-{$type}", action: $action, id: $id);
        }
    }
}
