<?php

namespace Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\RelationManagers;

use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Support\Colors\Color;
use Illuminate\Database\Eloquent\Model;
use Netzperfekt\SaasCodoc\Enums\AssetType;
use Netzperfekt\SaasCodoc\Filament\Resources\AssetResource\AssetResource;

class OrganisationAssetsRelationManager extends RelationManager
{
    protected static string $relationship = 'assets';
    protected static ?string $inverseRelationship = 'organisation';
    protected static bool $isLazy = false;

    public static function getRecordLabel(): string
    {
        return __('codoc-asset');
    }

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return __('codoc-assets');
    }

    public static function canViewForRecord(Model $ownerRecord, string $pageClass): bool
    {
        return $ownerRecord->type->hasAssets();
    }

    public function form(Form $form): Form
    {
        return $form
            ->columns(1)
            ->schema(AssetResource::getFormSchema($this->getOwnerRecord()->id));
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')

            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('codoc-description'))
                    ->weight(FontWeight::SemiBold)
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('manufacturer')
                    ->label(__('codoc-manufacturer'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('model')
                    ->label(__('codoc-model'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('location')
                    ->label(__('codoc-location'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('status')
                    ->label(__('codoc-status'))
                    ->badge()
            ])

            ->filters([
                Tables\Filters\SelectFilter::make('type')
                    ->label(__('codoc-type'))
                    ->options(AssetType::class)
            ])

            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->modalWidth('7xl')
            ])

            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('')
                    ->tooltip('Bearbeiten')
                    ->iconSize(IconSize::Medium)
                    ->modalWidth('7xl'),

                Tables\Actions\DeleteAction::make()
                    ->label('')
                    ->tooltip('Löschen')
                    ->iconSize(IconSize::Medium),
            ])

            ->bulkActions([
            ]);
    }
}
