<?php

namespace Netzperfekt\SaasCodoc\Filament\Resources\ServicePageResource\RelationManagers;

use Filament\Forms\Components\Actions\Action;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasCodoc\Filament\Components\Comments;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Models\Organisation;

class OrganisationUsesRelationManager extends RelationManager
{
    protected static string $relationship = 'organisationsUsing';
    protected static ?string $inverseRelationship = 'servicesUsing';
    protected static bool $isLazy = false;

    public static function getRecordLabel(): string
    {
        return __('codoc-organisation');
    }

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return __('codoc-services-used-by');
    }

    public function form(Form $form): Form
    {
        return $form
            ->columns(1)
            ->schema([
                TextInput::make('service_title')
                    ->label(__('codoc-title'))
                    ->required(),

                RichEditor::make('service_description')
                    ->label(__('codoc-description'))
                    ->defaultRichEditor(),

                TextInput::make('service_url')
                    ->url()
                    ->live()
                    ->label(__('codoc-service-url'))
                    ->suffixAction(Action::make('open-service-url')
                        ->icon('fas-link')
                        ->url(fn($get) => $get('service_url'))
                        ->disabled(fn($get) => $get('service_url') == '')
                        ->openUrlInNewTab()),

                Comments::make('service_comments')
                    ->label(__('codoc-comments'))
                    ->user(Auth::user())
                    ->editableOnlyOwnValues()
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->allowDuplicates()

            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('codoc-title'))
                    ->weight(FontWeight::SemiBold)
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('service_title')
                    ->label(__('codoc-description'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\IconColumn::make('service_url')
                    ->openUrl(),

                Tables\Columns\TextColumn::make('type')
                    ->label(__('codoc-type'))
                    ->badge()
                    ->color(Color::Green),
            ])

            ->filters([
                //
            ])

            ->headerActions([
                Tables\Actions\AttachAction::make()
                    ->color(Color::Yellow)
                    ->label(__('codoc-organisation-assign'))
                    ->recordSelect(
                        fn (Select $select) => $select
                            ->placeholder('Anbieter hinzufügen')
                            ->autofocus()
                            // ->multiple() // TODO hier klappt was bei apple/safari nicht - die buttons sind nicht erreichbar (css probleme?)
                    )
                    ->recordSelectOptionsQuery(fn(Builder $query) => $query->onlyMyRecords())
                    ->preloadRecordSelect(),
            ])

            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('')
                    ->tooltip('Bearbeiten')
                    ->iconSize(IconSize::Medium),

                Tables\Actions\Action::make('edit_organisation')
                    ->label('')
                    ->icon('heroicon-o-building-office')
                    ->color(Color::Orange)
                    ->iconSize(IconSize::Medium)
                    ->tooltip(__('codoc-edit-organisation'))
                    ->url(fn (Organisation $record): string
                        => OrganisationPageResource::getUrl('edit', ['record' => $record->organisation_id])),

                Tables\Actions\DetachAction::make()
                    ->label('')
                    ->tooltip('Trennen')
                    ->iconSize(IconSize::Medium)
            ])

            ->bulkActions([
            ])

            ->defaultSort('title', 'asc');
    }
}
