<?php

namespace Netzperfekt\SaasCodoc\Filament\Widgets;

use Filament\Facades\Filament;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\FontWeight;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Contracts\Support\Htmlable;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Models\OrganisationProvidesServices;
use Netzperfekt\SaasCodoc\Models\OrganisationUsesServices;

class CodocFavoritesWidget extends BaseWidget
{
    protected function getTableHeading(): string|Htmlable|null
    {
        return __('codoc-favorites');
    }

    public static function canView(): bool
    {
        return self::getFavorites()->count() > 0;
    }

    private static function getFavorites()
    {
        $organisations = Organisation::query()
            ->selectRaw('id, id as "organisation_id", title, 1 as "favtype", type as "type", "" as "service_title", 0 as "service_team"')
            ->where('is_favorite', '=', true)
            ->where('team_id', '=', Filament::getTenant()->id)
            ->orderBy('title');

        $servicesUsing = OrganisationUsesServices::query()
            ->selectRaw('codoc_organisation_uses_services.id, organisation_id as "organisation_id", service_title, 2 "favtype", 0 as "type", codoc_services.title as "service", codoc_services.team_id as "service_team"')
            ->leftJoin('codoc_services', 'codoc_services.id', '=', 'codoc_organisation_uses_services.service_id')
            ->where('is_favorite', '=', true)
            ->where('codoc_services.team_id', '=', Filament::getTenant()->id)
            ->orderBy('service_title');

        $servicesProviding = OrganisationProvidesServices::query()
            ->selectRaw('codoc_organisation_provides_services.id, organisation_id as "organisation_id", service_title, 3 "favtype", 0 as "type", codoc_services.title as "service", codoc_services.team_id as "service_team"')
            ->leftJoin('codoc_services', 'codoc_services.id', '=', 'codoc_organisation_provides_services.service_id')
            ->where('is_favorite', '=', true)
            ->where('codoc_services.team_id', '=', Filament::getTenant()->id)
            ->orderBy('service_title');

        return $organisations->union($servicesUsing)->union($servicesProviding);
    }

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getFavorites())

            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label('')
                    ->weight(FontWeight::Medium)

                    ->icon(function($record) {
                        return match ($record->favtype) {
                            1 => $record->type->getIcon(),

                            default => ''
                        };
                    })

                    ->url(function($record)
                    {
                        return match($record->favtype)
                        {
                            1 => OrganisationPageResource::getUrl('edit', [
                                $record->id
                            ]),

                            2 => OrganisationPageResource::getUrl('edit', [
                                'record' => $record->organisation_id,
                                'activeRelationManager' => 'servicesusing',
                                'deeplink' => 'servicesusing-edit-' . $record->id
                            ]),

                            3 => OrganisationPageResource::getUrl('edit', [
                                'record' => $record->organisation_id,
                                'activeRelationManager' => 'servicesproviding',
                                'deeplink' => 'servicesproviding-edit-' . $record->id
                            ]),

                            default => ''
                        };
                    }),

                Tables\Columns\TextColumn::make('favtype')
                    ->label('')
                    ->weight(FontWeight::Medium)
                    ->badge()
                    ->color(Color::Orange)
                    ->formatStateUsing(function($state)
                    {
                        return match($state)
                        {
                            1 => __('codoc-favtype-organisation'),
                            2 => __('codoc-favtype-service-using'),
                            3 => __('codoc-favtype-service-providing'),

                            default => ''
                        };
                    }),

                Tables\Columns\TextColumn::make('service_title')
                    ->label('')
            ]);
    }
}
