<?php

namespace Netzperfekt\SaasCodoc\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Netzperfekt\SaasCodoc\Filament\Resources\AssetResource\AssetResource;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Filament\Resources\ServicePageResource\ServicePageResource;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Models\Service;

class CodocOverviewWidget extends BaseWidget
{
    public static function canView(): bool
    {
        $ownOrganisation = Organisation::ownCompany()->first();

        return $ownOrganisation !== null;
    }

    protected function getStats(): array
    {
        $ownOrganisation = Organisation::getOwnCompany();
        $organisationsCount = Organisation::onlyMyRecords()->count();
        $servicesCount = Service::onlyMyRecords()->count();

        return [
            Stat::make(__('codoc-overview-own-organisation'), $ownOrganisation?->title)
                ->description($ownOrganisation?->company1)
                ->icon('heroicon-o-arrow-top-right-on-square')
                ->url(OrganisationPageResource::getUrl('edit', [$ownOrganisation])),

            Stat::make(__('codoc-overview-organisations'), $organisationsCount)
                ->icon('heroicon-o-building-office')
                ->url(OrganisationPageResource::getUrl('index')),

            Stat::make(__('codoc-overview-services'), $servicesCount)
                ->icon('heroicon-o-arrow-right-start-on-rectangle')
                ->url(ServicePageResource::getUrl('index')),

            Stat::make(__('codoc-overview-assets'), $servicesCount)
                ->icon('fas-laptop')
                ->url(AssetResource::getUrl('index')),
        ];
    }
}
