<?php

namespace Netzperfekt\SaasCodoc\Filament\Widgets;

use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Cookie;
use Netzperfekt\SaasCodoc\Filament\Resources\ServicePageResource\ServicePageResource;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Models\OrganisationUsesServices;
use Netzperfekt\SaasCodoc\Models\Service;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\SaasCodoc;

class CodocTodoWidget extends Widget
{
    protected static bool $isLazy = false;

    protected static string $view = SaasCodoc::PACKAGE_NAME . '::filament.widgets.todo';

    protected int|string|array $columnSpan = 'full';

    public array $todos = [];
    public bool $startOnboarding = false;

    public function __construct()
    {
        $services = Service::onlyMyRecords()->withoutTrashed()->withoutComponents();
        $organisations = Organisation::onlyMyRecords()->withoutTrashed();

        $servicesWithoutAssociations = (clone $services)->withoutAssociations()->count(); // withoutAssiociations modified $services!
        $organisationsWithoutAssociations = (clone $organisations)->withoutAssociations()->count();

        if($services->count() == 0 ||
            $organisations->count() <= 1 ||
            $services->first()->organisationsUsing->count() == 0 ||
            $services->first()->organisationsProviding->count() == 0 ||
            ! Cookie::has('_documentation_exported')
        )
        {
            $this->startOnboarding = true;
        }

        if($servicesWithoutAssociations > 0)
        {
            $this->todos[] = [
                'badge'     => $servicesWithoutAssociations,
                'text'      => __('codoc-todo-services-without-associations'),
                'linkLabel' => __('codoc-todo-fixnow'),
                'linkUrl'   => ServicePageResource::getUrl('index') . '?tableFilters[without_associations][without_associations]=true'
            ];
        }

        if($organisationsWithoutAssociations > 0)
        {
            $this->todos[] = [
                'badge'     => $organisationsWithoutAssociations,
                'text'      => __('codoc-todo-organisations-without-associations'),
                'linkLabel' => __('codoc-todo-fixnow'),
                'linkUrl'   => OrganisationPageResource::getUrl('index') . '?tableFilters[without_associations][without_associations]=true'
            ];
        }
    }
}
