<?php

namespace Netzperfekt\SaasCodoc\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasCodoc\Enums\AssetStatus;
use Netzperfekt\SaasCodoc\Enums\AssetType;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Asset extends Model
{
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;
    use LogsActivity;

    protected $table = 'codoc_assets';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'team_id',
        'organisation_id',
        'type',
        'key',
        'title',
        'description',
        'manufacturer',
        'model',
        'serial_number',
        'inventory_number',
        'location',
        'buy_date',
        'tags',
        'status',
        'comments'
    ];

    protected $casts = [
        'tags'     => 'array',
        'comments' => 'array',
        'type'     => AssetType::class,
        'status'   => AssetStatus::class,
        'buy_date' => 'datetime',
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function organisation(): BelongsTo
    {
        return $this->belongsTo(Organisation::class);
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(['status', 'comments'])
            ->dontLogIfAttributesChangedOnly(['updated_at'])
            ->dontSubmitEmptyLogs()
            ->logOnlyDirty(true);
    }
}
