<?php

namespace Netzperfekt\SaasCodoc\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Netzperfekt\SaasCodoc\Enums\ServiceStatus;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class OrganisationProvidesServices extends Pivot
{
    use LogsActivity;

    protected $table = 'codoc_organisation_provides_services';
    public $incrementing = true;

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'service_title',
        'service_description',
        'service_id',
        'organisation_id',
        'service_comments',
        'service_url',
        'service_status',
        'service_needs_dpa',
        'service_documents',
        'service_additional',
        'is_favorite',
        'sort_order'
    ];

    protected $casts = [
        'service_comments'      => 'array',
        'service_documents'     => 'array',
        'service_additional'    => 'array',
        'service_status'        => ServiceStatus::class
    ];

    public function toggleFavorite(): void
    {
        $this->is_favorite = ! $this->is_favorite;
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(['service_comments', 'service_needs_dpa', 'service_documents'])
            ->dontLogIfAttributesChangedOnly(['updated_at'])
            ->dontSubmitEmptyLogs()
            ->logOnlyDirty(true);
    }
}
