<?php

namespace Netzperfekt\SaasCodoc\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Netzperfekt\SaasCodoc\Enums\ServiceStatus;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class OrganisationUsesServices extends Pivot
{
    use LogsActivity;

    protected $table = 'codoc_organisation_uses_services';
    public $incrementing = true;

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'service_title',
        'service_description',
        'organisation_provided_id',
        'service_id',
        'organisation_id',
        'service_comments',
        'service_url',
        'service_status',
        'service_needs_dpa',
        'service_documents',
        'service_additional',
        'is_favorite',
        'sort_order'
    ];

    protected $casts = [
        'service_comments'      => 'array',
        'service_documents'     => 'array',
        'service_additional'    => 'array',
        'service_status'        => ServiceStatus::class
    ];

    public function organisationProvided(): BelongsTo
    {
        return $this->belongsTo(Organisation::class, 'organisation_provided_id', 'id');
    }

    public function toggleFavorite(): void
    {
        $this->is_favorite = ! $this->is_favorite;
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(['service_comments', 'service_needs_dpa', 'service_documents'])
            ->dontLogIfAttributesChangedOnly(['updated_at'])
            ->dontSubmitEmptyLogs()
            ->logOnlyDirty(true);
    }
}
