<?php

namespace Netzperfekt\SaasCodoc\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasBase\Models\User;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasCodoc\Enums\ServiceDocType;

class ServiceDoc extends Model
{
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'codoc_services_doc';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'service_id',
        'user_id',
        'type',
        'title',
        'documentation',
        'extra',
        'ticketid'
    ];

    protected $casts = [
        'documentation' => 'array',
        'extra'         => 'array',
        'type'          => ServiceDocType::class,
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    protected static function booted(): void
    {
        static::creating(function (ServiceDoc $doc)
        {
            if(! $doc->created_at)
            {
                $doc->created_at = Carbon::now();
            }

            $doc->user_id = Auth::user()->id;
        });
    }
}
