<?php

namespace Netzperfekt\SaasCodoc\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

class ServicesComponents extends Pivot
{
    protected $table = 'codoc_services_components';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'service_id',
        'component_id',
        'component_title',
        'component_description',
        'component_comments',
        'sort_order'
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class, 'component_id', 'id');
    }
}
