<?php

namespace Netzperfekt\SaasCodoc;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Filament\Support\Facades\FilamentView;
use Filament\View\PanelsRenderHook;
use Illuminate\View\View;
use Netzperfekt\SaasCodoc\Filament\Pages\Dependencies;
use Netzperfekt\SaasCodoc\Filament\Pages\ExportDocumentation;
use Netzperfekt\SaasCodoc\Filament\Resources\AssetResource\AssetResource;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Filament\Resources\ServicePageResource\ServicePageResource;

class SaasCodoc implements Plugin
{
    public final const PACKAGE_NAME = 'saas-codoc';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';

    public static function make(): SaasCodoc
    {
        return new SaasCodoc();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activeResources = [];
            $activePages = [];

            if($this->getForTenants())
            {
                $activeResources = [
                    OrganisationPageResource::class,
                    ServicePageResource::class,
                    AssetResource::class
                ];

                $activePages = [
                    ExportDocumentation::class,
                    // TODO wieder rein Dependencies::class
                ];
            }
            else
            {
                // activate resources / pages for admin panel
            }

            $panel->resources($activeResources);
            $panel->pages($activePages);
        }
    }

    public function boot(Panel $panel): void
    {
        FilamentView::registerRenderHook(
            PanelsRenderHook::GLOBAL_SEARCH_AFTER,
            fn(): View => view('saas-codoc::filament.panels-topbar')
        );
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }
}
