<?php

namespace Netzperfekt\SaasCodoc\Services;

use Filament\Contracts\Plugin;
use Illuminate\Support\Facades\Cookie;
use Netzperfekt\SaasCodoc\Filament\Pages\ExportDocumentation;
use Netzperfekt\SaasCodoc\Filament\Resources\OrganisationPageResource\OrganisationPageResource;
use Netzperfekt\SaasCodoc\Filament\Resources\ServicePageResource\ServicePageResource;
use Netzperfekt\SaasCodoc\Models\Organisation;
use Netzperfekt\SaasCodoc\Models\Service;
use RalphJSmit\Filament\Onboard\FilamentOnboard;
use RalphJSmit\Filament\Onboard\Step;
use RalphJSmit\Filament\Onboard\Track;

class Onboarding
{
    public static function make(): Plugin
    {
        return FilamentOnboard::make()
            ->addTrack(fn () => Track::make([

                Step::make(name: 'Erstelle jetzt Deine Daten', identifier: 'widget::create-organisation')
                    ->description('Beschreibe Deine Organisation.')
                    ->performStepActionLabel('Jetzt eingeben →')
                    ->url(OrganisationPageResource::getUrl('create'))
                    ->columnSpan(1)
                    ->completeIf(fn () => Organisation::getOwnCompany()),

                Step::make(name: 'Erstelle eine weitere Organisation', identifier: 'widget::create-another-organisation')
                    ->description('Gib Daten für eine weitere Organisation oder einen Kontakt ein.')
                    ->performStepActionLabel('Jetzt erstellen →')
                    ->url(OrganisationPageResource::getUrl('create'))
                    ->columnSpan(1)
                    ->completeIf(fn () => Organisation::onlyMyRecords()->count() >= 2),

                Step::make(name: 'Erstelle einen ersten Dienst', identifier: 'widget::create-service')
                    ->description('Gib Daten für einen Dienst/Service ein.')
                    ->performStepActionLabel('Jetzt erstellen →')
                    ->url(ServicePageResource::getUrl('create'))
                    ->columnSpan(1)
                    ->completeIf(fn () => Service::onlyMyRecords()->count() > 0),

            ])->columns(3)

        )->addTrack(fn () => Track::make([

                Step::make(name: 'Verknüpfe jetzt Deine Daten', identifier: 'widget::assign-service')
                    ->description('Verknüpfe Deinen Dienst/Service mit einer Organisation.')
                    ->performStepActionLabel('Jetzt verknüpfen →')
                    ->url(function()
                    {
                        $service = Service::onlyMyRecords()->first();

                        return ServicePageResource::getUrl('edit', ['record' => $service]);
                    })
                    ->columnSpan(1)
                    ->completeIf(function()
                    {
                        $service = Service::onlyMyRecords()->first();

                        return $service->organisationsUsing->count() > 0 && $service->organisationsProviding->count() > 0;
                    }),

                Step::make(name: 'Exportiere Deine Daten', identifier: 'widget::export-data')
                    ->description('Exportiere Deine Daten und schau Dir das Ergebnis an.')
                    ->performStepActionLabel('Jetzt exportieren →')
                    ->url(ExportDocumentation::getUrl())
                    ->columnSpan(1)
                    ->completeIf(fn () => Cookie::has('_documentation_exported'))

            ])->columns(3)
        );
    }
}
