<?php

use Illuminate\Support\Str;
use Netzperfekt\SaasCodoc\Models\ExportLink;

if (! function_exists('getExportLink'))
{
    function getExportLink(array $params, int $userId): string
    {
        $organisations = $params['organisations'];
        $organisationIds = array_keys($organisations->toArray());
        $myOrganisationId = $params['myorganisation']->id;

        $params['organisations'] = $organisationIds;
        $params['myorganisation'] = $myOrganisationId;
        $params['user'] = $userId;

        $hash = hash('sha256', json_encode($params));

        $exportLink = ExportLink::where('hash', '=', $hash)->first();
        if($exportLink)
        {
            return route('codoc.export.codoc', ['link' => $exportLink->link]);
        }

        $link = Str::random(10);
        $exportLink = ExportLink::where('link', '=', $link)->first();
        while($exportLink || strlen($link) < 6)
        {
            $link = Str::random(10);
            $exportLink = ExportLink::where('link', '=', $link)->first();
        }

        $exportLink = ExportLink::create([
            'hash'   => $hash,
            'link'   => $link,
            'params' => $params,
        ]);

        return route('codoc.export.codoc', ['link' => $link]);
    }
}