<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasDeadman\Enums\ActionType;
use Netzperfekt\SaasDeadman\Models\Action;

class ActionFactory extends Factory
{
    protected $model = Action::class;

    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement(ActionType::cases())->value,
            'subject' => $this->faker->word(),
            'contents' => $this->faker->words(),
            'attach_contents' => $this->faker->boolean(),
            'encrypted' => false, // TODO maybe later

            'team_id' => Team::factory(),
        ];
    }

    public function withTeam(Team $team): Factory
    {
        return $this->state(function (array $attributes) use ($team) {
            return [
                'team_id' => $team->id
            ];
        });
    }
}
