<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Netzperfekt\SaasDeadman\Enums\ChannelType;
use Netzperfekt\SaasDeadman\Models\Channel;

class ChannelFactory extends Factory
{
    protected $model = Channel::class;

    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement(ChannelType::cases())->value,
            'active' => $this->faker->boolean(),
            'key' => $this->faker->word(),
            'title' => $this->faker->word(),
            'description' => $this->faker->text()
        ];
    }

    public function active(): Factory
    {
        return $this->state(function (array $attributes) {
            return [
                'active' => true
            ];
        });
    }

    public function email(): Factory
    {
        return $this->state(function (array $attributes) {
            return [
                'type' => ChannelType::EMail
            ];
        });
    }
}
