<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasDeadman\Enums\ConfirmationFrequency;
use Netzperfekt\SaasDeadman\Enums\ContactType;
use Netzperfekt\SaasDeadman\Models\Contact;

class ContactFactory extends Factory
{
    protected $model = Contact::class;

    public function definition(): array
    {
        $team = Team::factory()->create();
        $lastConfirmation = $this->faker->dateTimeBetween('-1 week', 'now');
        $nextConfirmation = $this->faker->dateTimeBetween($lastConfirmation->add(\DateInterval::createFromDateString('10 minutes')), '+4 weeks');

        return [
            'type' => $this->faker->randomElement(ContactType::cases())->value,
            'lastname' => $this->faker->lastName(),
            'firstname' => $this->faker->firstName(),
            'company' => $this->faker->company(),
            'street' => $this->faker->streetName(),
            'zip' => $this->faker->postcode(),
            'city' => $this->faker->city(),
            'country' => $this->faker->country(),
            'comments' => $this->faker->text(),
            'must_confirm' => $this->faker->boolean(),

            'confirmation_frequency' => $this->faker->randomElement(ConfirmationFrequency::cases())->value,
            'last_confirmation' => $lastConfirmation,
            'next_confirmation' => $nextConfirmation,

            'team_id' => $team,
        ];
    }

    public function ownContact(): Factory
    {
        return $this->state(function (array $attributes) {
            return [
                'type' => ContactType::Myself
            ];
        });
    }

    public function withTeam(Team $team): Factory
    {
        return $this->state(function (array $attributes) use ($team) {
            return [
                'team_id' => $team->id
            ];
        });
    }
}
