<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Netzperfekt\SaasDeadman\Models\Channel;
use Netzperfekt\SaasDeadman\Models\Contact;
use Netzperfekt\SaasDeadman\Models\ContactRecipient;

class ContactRecipientFactory extends Factory
{
    protected $model = ContactRecipient::class;

    public function definition(): array
    {
        return [
            'channel_id'    => 0,
            'contact_id'    => 0,
            'recipients'    => [],
            'confirmations' => []
        ];
    }

    public function contact(Contact $contact): Factory
    {
        return $this->state(function (array $attributes) use ($contact) {
            return [
                'contact_id' => $contact->id
            ];
        });
    }

    public function channel(Channel $channel): Factory
    {
        return $this->state(function (array $attributes) use ($channel) {
            return [
                'channel_id' => $channel->id
            ];
        });
    }

    public function recipients(array $recipients): Factory
    {
        return $this->state(function (array $attributes) use ($recipients) {
            return [
                'recipients' => $recipients
            ];
        });
    }
}
