<x-mail::message>
    <style>
        .content-title {
            font-weight: bold;
            font-size: 130%;
            margin-top: 1rem;
            margin-bottom: .5rem;
        }

        .content-field {
            background-color: #eee;
            padding: .5rem;

            ul {
                li {
                    margin-bottom: .5rem;
                }
            }
        }
    </style>

    {{-- Greeting --}}
    @if (! empty($greeting))
        # {{ $greeting }}
    @else
        @if ($level === 'error')
            # @lang('Whoops!')
        @else
            # @lang('Hello!')
        @endif
    @endif

    {{-- Intro Lines --}}
    @foreach ($introLines as $line)
        {{ $line }}

    @endforeach

    {{-- Action Button --}}
    @isset($actionText)
            <?php
            $color = match ($level) {
                'success', 'error' => $level,
                default => 'primary',
            };
            ?>
        <x-mail::button :url="$actionUrl" :color="$color">
            {{ $actionText }}
        </x-mail::button>
    @endisset

    {{-- Outro Lines --}}
    @foreach ($outroLines as $line)
        {{ $line }}

    @endforeach

    {{-- Salutation --}}
    @if (! empty($salutation))
        {{ $salutation }}
    @else
        @lang('Regards'),<br>
        {{ config('app.name') }}
    @endif

    {{-- Subcopy --}}
    @isset($actionText)
        <x-slot:subcopy>
            @lang(
                "Wenn Sie Schwierigkeiten haben, den obenstehenden Button zu klicken, können Sie den folgenden Link kopieren und direkt im Browser einfügen:",
                [
                    'actionText' => $actionText
                ]
            ) <span class="break-all">[{{ $displayableActionUrl }}]({{ $actionUrl }})</span>
        </x-slot:subcopy>
    @endisset
</x-mail::message>
