<?php

use Illuminate\Support\Facades\Route;
use Netzperfekt\SaasDeadman\Controllers\ConfirmationController;
use Netzperfekt\SaasDeadman\Controllers\NotificationController;
use Netzperfekt\SaasDeadman\Controllers\ProxyController;
use Netzperfekt\SaasDeadman\Middleware\NoIndexMiddleware;
use ParagonIE\Halite\KeyFactory;
use ParagonIE\HiddenString\HiddenString;
use ParagonIE\Halite\Symmetric\Crypto as Symmetric;

Route::prefix('front')
    ->middleware([NoIndexMiddleware::class])
    ->group(function ()
{
    Route::get('/switch/confirm/{switchId}/{contactId}/{confirmhash?}',
        [ConfirmationController::class, 'confirmSwitch'])
        ->name('front.switch.confirm');

    Route::get('/test/{channelId}/{switchId}',
        [NotificationController::class, 'test'])
        ->name('front.mail.test');

    Route::any('/verify/{channelId}/{contactId}/{recipient}/{confirmhash?}',
        [NotificationController::class, 'verify'])
        ->name('front.mail.verify');

    Route::get('/notification/show/{switchId}/{actionId}/{contactId}/{confirmhash?}',
        [NotificationController::class, 'showNotification'])
        ->name('front.notification.show');

    Route::get('/download/{teamId}/{disk}/{filename}',
        [ProxyController::class, 'downloadAttachmentFrontend'])
        ->name('front.attachment.download');
});

Route::middleware(['web'])->group(function ()
{
    Route::get(
        '/proxy/download/{disk}/{filename}',
        [ProxyController::class, 'downloadAttachment']
    )->name('proxy.download');


    // TODO raus
    Route::Get('test1', function()
    {
        dd(\Illuminate\Support\Facades\Storage::disk('do_attachments')->allFiles());
    });

    // TODO raus
    Route::get('test', function()
    {
        $encKey = KeyFactory::generateEncryptionKey();

        $userId = 42;
        $keyPath = storage_path('keys/user' . $userId . '.key');

        if(! file_exists(dirname($keyPath))) {
            mkdir(dirname($keyPath));
        }

        KeyFactory::save($encKey, $keyPath);

        // ---

        $encryptionKey = KeyFactory::loadEncryptionKey($keyPath);

        $message = new HiddenString('This is a confidential message for your eyes only.');
        $ciphertext = Symmetric::encrypt($message, $encryptionKey);

        $decrypted = Symmetric::decrypt($ciphertext, $encryptionKey);

        dd($decrypted->getString());
    });
});
