<?php

namespace Netzperfekt\SaasDeadman\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Encryption\Encrypter;
use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasDeadman\Encryption\Encryption;

class EncryptedCast implements CastsAttributes
{
    public function get(Model $model, string $key, mixed $value, array $attributes): array
    {
        if(empty($value)) {
            return [];
        }

        $encryptionKey = Encryption::getEncryptionKeyFor(Auth::user()->getCurrentTeamId());
        $encrypter = new Encrypter($encryptionKey, 'aes-256-gcm');

        return json_decode($encrypter->decrypt($value), true);
    }

    public function set(Model $model, string $key, mixed $value, array $attributes): string
    {
        $encryptionKey = Encryption::getEncryptionKeyFor(Auth::user()->getCurrentTeamId());
        $encrypter = new Encrypter($encryptionKey, 'aes-256-gcm');

        return $encrypter->encrypt(json_encode($value));
    }
}
