<?php

declare(strict_types=1);

namespace Netzperfekt\SaasDeadman\Commands;

use Illuminate\Console\Command;
use Netzperfekt\SaasDeadman\Enums\ActivityLogType;
use Netzperfekt\SaasDeadman\Facades\SwitchService;

class CheckSwitchesCommand extends Command
{
    protected $signature = 'switches:check';

    protected $description = 'Checks switches to be processed.';

    public function getSignature()
    {
        return $this->signature;
    }

    public function handle(): int
    {
        // TODO schöner formattieren, mit ->table() oder so

        $counter = SwitchService::checkSwitches();

        $this->info('results');
        foreach($counter as $counterName => $value)
        {
            $this->info($counterName . ': ' . $value);
        }

        if(count($counter) > 0)
        {
            activity()
                ->withProperties([
                    'results' => $counter
                ])
                ->log(ActivityLogType::CommandLineInterface->value . '_' . $this->signature);
        }

        return self::SUCCESS;
    }
}
