<?php

namespace Netzperfekt\SaasDeadman\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProxyController extends Controller
{
    public function downloadAttachment(string $disk, string $fileName)
    {
        $fileName = urldecode($fileName);

        return Storage::disk($disk)->download($fileName);
    }

    public function downloadAttachmentFrontend(Request $request, int $teamId, string $disk, string $fileName)
    {
        if (! $request->hasValidSignature()) {
            abort(401);
        }

        loginAsTeam($teamId);

        $fileName = urldecode($fileName);

        return Storage::disk($disk)->download($fileName);
    }
}
