<?php

declare(strict_types=1);

namespace Netzperfekt\SaasDeadman\Encryption;

use Illuminate\Encryption\Encrypter;

class Encryption
{
    private static function getEncryptionKeyPath(int $teamId): string
    {
        return storage_path('keys/team' . $teamId . '.key');
    }

    public static function createEncryptionKey(int $teamId): string
    {
        $encryptionKey = Encrypter::generateKey('aes-256-gcm');
        $keyPath = self::getEncryptionKeyPath($teamId);

        if(! file_exists(dirname($keyPath)))
        {
            mkdir(dirname($keyPath));
        }

        file_put_contents($keyPath, $encryptionKey);

        return $encryptionKey;
    }

    public static function getEncryptionKeyFor(int $teamId): string
    {
        $keyPath = self::getEncryptionKeyPath($teamId);
        if( ! file_exists($keyPath))
        {
            $encryptionKey = self::createEncryptionKey($teamId);
        }
        else {
            $encryptionKey = file_get_contents($keyPath);
        }

        return $encryptionKey;
    }
}