<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ActionType: int implements HasLabel, HasIcon
{
    case Notification   = 0;
    case UrlHook        = 1;

    public function getLabel(): ?string
    {
        return match ($this)
        {
            self::Notification => __('deadman-enum-action-notification'),
            self::UrlHook      => __('deadman-enum-action-urlhook')
        };
    }

    public function getIcon(): ?string
    {
        return match ($this)
        {
            self::Notification  => 'far-envelope',
            self::UrlHook       => 'fas-link'
        };
    }
}
