<?php

namespace Netzperfekt\SaasDeadman\Enums;

enum ActivityLogType: string
{
    case CommandLineInterface          = 'cli';

    case VerifyRecipientsPre           = 'verify_pre';
    case VerifyRecipients              = 'verify';

    case ShowNotificationPre           = 'show_notification_pre';
    case ShowNotification              = 'show_notification';
    case ShowNotificationWithdrawn     = 'show_notification_withdrawn';

    case SwitchConfirmed               = 'switch_confirmed';
    case SwitchConfirmationPre         = 'switch_confirmation_pre';

    case SwitchStateIdle               = 'switch_state_idle';
    case SwitchStateConfirmed          = 'switch_state_confirmed';
    case SwitchTriggered               = 'switch_triggered';

    case TestNotificationSent          = 'test_notification_sent';
    case VerificationNotificationSent  = 'verification_notification_sent';
    case ConfirmationNotificationsSent = 'confirmation_notifications_sent';
    case TriggerNotificationsSent      = 'trigger_notifications_sent';

    case Error                         = '_error';
}
