<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;
use Illuminate\Notifications\Slack\SlackChannel;

enum ChannelType: int implements HasLabel, HasIcon
{
    case EMail      =  0;
    case Sms        =  1;
    case WhatsApp   = 10;
    case Slack      = 20;
    case PushApp    = 90;

    public function getLabel(): ?string
    {
        return match ($this)
        {
            self::EMail     => __('deadman-enum-channel-email'),
            self::Sms       => __('deadman-enum-channel-sms'),
            self::WhatsApp  => __('deadman-enum-channel-whatsapp'),
            self::Slack     => __('deadman-enum-channel-slack'),
            self::PushApp   => __('deadman-enum-channel-app'),
            self::Database  => __('deadman-enum-channel-database')
        };
    }

    public function getIcon(): ?string
    {
        return match ($this)
        {
            self::EMail    => 'fas-envelope',
            self::Sms      => 'fas-comment-sms',
            self::WhatsApp => 'fab-whatsapp',
            self::Slack    => 'fab-slack',
            self::PushApp  => 'fas-mobile-screen-button'
        };
    }

    public function getValidationRule(): ?string
    {
        return match ($this)
        {
            self::EMail    => 'email',
            self::Sms      => 'regex:/^([0-9\s\-\+\(\)]*)$/',
            self::WhatsApp => '',
            self::Slack    => '',
            self::PushApp  => ''
        };
    }

    public function getNotificationChannel(): ?string
    {
        return match ($this)
        {
            self::EMail    => 'mail',
            self::Sms      => '',
            self::WhatsApp => '',
            self::Slack    => SlackChannel::class,
            self::PushApp  => ''
        };
    }
}
