<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Carbon\Carbon;
use Filament\Support\Contracts\HasLabel;

enum ConfirmationFrequency: string implements HasLabel
{
    case Once       =  'o';
    case Daily      =  'd';
    case Weekly     =  'w';
    case Monthly    =  'm';
    case Quarterly  =  'q';

    case Hourly     = 'h';
    case Hourly4    = 'h4';
    case Hourly8    = 'h8';
    case Hourly12   = 'h12';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Once      => __('deadman-enum-confirmation-frequency-once'),
            self::Daily     => __('deadman-enum-confirmation-frequency-daily'),
            self::Weekly    => __('deadman-enum-confirmation-frequency-weekly'),
            self::Monthly   => __('deadman-enum-confirmation-frequency-monthly'),
            self::Quarterly => __('deadman-enum-confirmation-frequency-quarterly'),

            self::Hourly    => __('deadman-enum-confirmation-frequency-hourly'),
            self::Hourly4   => __('deadman-enum-confirmation-frequency-hourly4'),
            self::Hourly8   => __('deadman-enum-confirmation-frequency-hourly8'),
            self::Hourly12  => __('deadman-enum-confirmation-frequency-hourly12'),
        };
    }

    public function getNextConfirmationDate(?Carbon $lastConfirmation = null): Carbon
    {
        if($lastConfirmation == null)
        {
            $lastConfirmation = Carbon::now();
        }

        return match ($this)
        {
            self::Once      => null,
            self::Daily     => $lastConfirmation->addDay(),
            self::Weekly    => $lastConfirmation->addWeek(),
            self::Monthly   => $lastConfirmation->addMonth(),
            self::Quarterly => $lastConfirmation->addMonths(3),

            self::Hourly    => $lastConfirmation->addHour(),
            self::Hourly4   => $lastConfirmation->addHours(4),
            self::Hourly8   => $lastConfirmation->addHours(8),
            self::Hourly12  => $lastConfirmation->addHours(12)
        };
    }

    public function showHighFrequencyWarning(): bool
    {
        return match ($this)
        {
            self::Once      => false,
            self::Daily     => true,
            self::Weekly    => false,
            self::Monthly   => false,
            self::Quarterly => false,

            self::Hourly    => true,
            self::Hourly4   => true,
            self::Hourly8   => true,
            self::Hourly12  => true
        };
    }

    public static function getOptions(array $excludeOptions = [])
    {
        return array_reduce(self::cases(), function ($carry, $case) use ($excludeOptions): ?array
        {
            if(!in_array($case->value, $excludeOptions))
            {
                $carry[$case->value] = $case->getLabel();
            }

            return $carry;
        });
    }
}
