<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Carbon\Carbon;
use Filament\Support\Contracts\HasLabel;

enum ConfirmationFrequencyGrace: string implements HasLabel
{
    case None       =  '-';

    case Hours1    = 'h';
    case Hours2    = 'h2';
    case Hours4    = 'h4';
    case Hours8    = 'h8';
    case Hours12   = 'h12';

    case Days1     = 'd';
    case Days2     = 'd2';
    case Days3     = 'd3';
    case Days7     = 'd7';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::None      => __('deadman-enum-confirmation-frequency-none'),

            self::Hours1  => __('deadman-enum-confirmation-frequency-hours1'),
            self::Hours2  => __('deadman-enum-confirmation-frequency-hours2'),
            self::Hours4  => __('deadman-enum-confirmation-frequency-hours4'),
            self::Hours8  => __('deadman-enum-confirmation-frequency-hours8'),
            self::Hours12 => __('deadman-enum-confirmation-frequency-hours12'),

            self::Days1   => __('deadman-enum-confirmation-frequency-days1'),
            self::Days2   => __('deadman-enum-confirmation-frequency-days2'),
            self::Days3   => __('deadman-enum-confirmation-frequency-days3'),
            self::Days7   => __('deadman-enum-confirmation-frequency-days7'),
        };
    }

    public function addGracePeriod(?Carbon $lastConfirmation = null): Carbon
    {
        if($lastConfirmation === null)
        {
            $lastConfirmation = Carbon::now();
        }

        return match ($this)
        {
            self::None    => $lastConfirmation,

            self::Hours1  => $lastConfirmation->addHours(1),
            self::Hours2  => $lastConfirmation->addHours(2),
            self::Hours4  => $lastConfirmation->addHours(4),
            self::Hours8  => $lastConfirmation->addHours(8),
            self::Hours12 => $lastConfirmation->addHours(12),

            self::Days1   => $lastConfirmation->addDays(1),
            self::Days2   => $lastConfirmation->addDays(2),
            self::Days3   => $lastConfirmation->addDays(3),
            self::Days7   => $lastConfirmation->addDays(7),
        };
    }
}
