<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ContactType: int implements HasLabel, HasIcon
{
    case Customer        = 0;
    case Supplier        = 1;
    case Stakeholder     = 2;
    case Finance         = 3;
    case Legal           = 4;

    case PrivatePartner  = 10;
    case Parents         = 11;
    case Children        = 12;
    case Siblings        = 13;
    case PrivateOther    = 19;

    case Myself          = 99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Customer        => __('deadman-enum-contact-customer'),
            self::Supplier        => __('deadman-enum-contact-supplier'),
            self::Stakeholder     => __('deadman-enum-contact-stakeholder'),
            self::Finance         => __('deadman-enum-contact-finance'),
            self::Legal           => __('deadman-enum-contact-legal'),

            self::PrivatePartner  => __('deadman-enum-contact-partner'),
            self::Parents         => __('deadman-enum-contact-parents'),
            self::Children        => __('deadman-enum-contact-children'),
            self::Siblings        => __('deadman-enum-contact-siblings'),

            self::PrivateOther    => __('deadman-enum-contact-other'),
            self::Myself          => __('deadman-enum-contact-myself'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Customer        => 'fas-people-arrows',
            self::Supplier        => 'fas-person-walking-arrow-right',
            self::Stakeholder     => 'fas-people-group',
            self::Finance         => 'fas-coins',
            self::Legal           => 'fas-section',

            self::PrivatePartner  => 'fas-people-arrows',
            self::Parents         => 'fas-people-roof',
            self::Children        => 'fas-children',
            self::Siblings        => 'fas-people-group',
            self::PrivateOther    => 'fas-person',

            self::Myself          => 'fas-person-burst',
        };
    }
}