<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Colors\Color;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum SwitchStateEnum: string implements HasLabel, HasIcon, HasColor
{
    case Idle        = 'idle';
    case Overdue     = 'overdue';
    case MustConfirm = 'mustconfirm';
    case GracePeriod = 'graceperiod';
    case Triggered   = 'triggered';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Idle        => __('deadman-enum-switchstate-idle'),
            self::Overdue     => __('deadman-enum-switchstate-overdue'),
            self::MustConfirm => __('deadman-enum-switchstate-mustconfirm'),
            self::GracePeriod => __('deadman-enum-switchstate-graceperiod'),
            self::Triggered   => __('deadman-enum-switchstate-triggered')
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Idle => 'heroicon-o-check',
            self::Overdue => 'heroicon-o-question-mark-circle',
            self::MustConfirm => 'heroicon-o-exclamation-triangle',
            self::GracePeriod => 'heroicon-o-clock',
            self::Triggered => 'heroicon-s-bell-alert'
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::Idle => Color::Green,
            self::Overdue => Color::Yellow,
            self::MustConfirm => Color::Orange,
            self::GracePeriod => Color::Blue,
            self::Triggered => Color::Red
        };
    }

    public function getBackgroundColor(): string | array | null
    {
        return match ($this) {
            self::Idle => '',
            self::Overdue => 'bg-yellow-100',
            self::MustConfirm => 'bg-orange-100',
            self::GracePeriod => 'bg-blue-100',
            self::Triggered => 'bg-red-100'
        };
    }
}
