<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum SwitchType: int implements HasLabel, HasIcon
{
    case Default   = 0;
    case Panic     = 1;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Default  => __('deadman-enum-switch-default'),
            self::Panic    => __('deadman-enum-switch-panic'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Default  => 'fas-toggle-off',
            self::Panic    => 'fas-toggle-on',
        };
    }
}
