<?php

namespace Netzperfekt\SaasDeadman\Filament\Components;

use Filament\Forms\Components\Field;

class FileDownload extends Field
{
    protected string $view = 'saas-deadman::forms.components.file-download';

    protected string | array | \Closure | null $fileNames = null;
    protected string | \Closure | null $proxyRoute = null;
    protected string | \Closure | null $disk = null;

    public function fileNames(string | array | \Closure | null $fileNames): static
    {
        $this->fileNames = $fileNames;

        return $this;
    }

    public function getFileNames(): string | array | null
    {
        return $this->evaluate($this->fileNames);
    }

    public function proxyRoute(string | \Closure | null $proxyRoute): static
    {
        $this->proxyRoute = $proxyRoute;

        return $this;
    }

    public function getProxyRoute(): string | null
    {
        return $this->evaluate($this->proxyRoute);
    }

    public function disk(string | \Closure | null $disk): static
    {
        $this->disk = $disk;

        return $this;
    }

    public function getDisk(): string | null
    {
        return $this->evaluate($this->disk);
    }

    public function getDownloadUrl(string $fileName): string | null
    {
        return route($this->proxyRoute, [
            'disk'     => $this->getDisk(),
            'filename' => urlencode(urlencode($fileName))
        ]);
    }

    public function isValid(string $fileName): bool
    {
        return ! str_contains($fileName, 'tmp');
    }
}
